<?php

/**
 * Do not change this value if there is no DataTables translation available for your language.
 * You can check out the available translations using the following link.
 * @link https://cdn.datatables.net/plug-ins/1.10.19/i18n/
 */
$GLOBALS["dataTablesLanguage"] = "Spanish";

$lang = [
    'disabled_by_admin' => 'Inhabilitado por el administrador',
    'remaining' => 'Restante',
    'per_message' => 'Por mensaje',
    'length' => 'Longitud',
    'encoding' => 'Codificación',
    'expired' => 'Caducada',
    'admin' => 'Admin',
    'info' => 'Información',
    'subscription' => 'Suscripción',
    'mass_mms_instructions' => '<p>Puede enviar un MMS masivo separando los números móviles usando el símbolo de barra vertical (|) en lugar de la coma (,). Enviará un MMS a varios números, como la funcionalidad BCC en el correo electrónico. Por ejemplo, considere los siguientes números.</p>
<p style="word-break: break-all">+11234567890|+12345678901|+13456789012,+14567890123,+15678901234</p>
<p>Enviará tres mensajes si ingresa números móviles como este. El primer mensaje será un mensaje masivo al +11234567890, +12345678901 y +13456789012.</p>
<p>Esto solo funcionará si su operador de red admite MMS masivo.</p>',
    'announcement_setting' => 'Anuncio',
    'error_invalid_firebase_service_account_json' => '¡La cuenta de servicio de Firebase json no es válida!',
    'firebase_service_account' => 'Cuenta de servicio de Firebase',
    'canceled' => 'Cancelada',
    'no_data' => 'Sin datos',
    'last_login_ip' => 'Última IP de inicio de sesión',
    'message_placeholder' => 'Puedes aleatorizar el mensaje usando spintax como se muestra a continuación.
&quot;{Hi|Hola|Hey} %name%, ¿Cómo estás?&quot;',
    'ussd_delay' => 'Retraso antes de la solicitud USSD',
    'how_to_get_it' => '¿Cómo obtenerlo?',
    'tooltip_ussd' => 'Una solicitud USSD de múltiples pasos espera hasta 30 segundos para la siguiente entrada, por lo que puedes enviar otra solicitud con la entrada en ese período de tiempo para pasar al siguiente paso. Por ejemplo, si inicias una solicitud de múltiples pasos y acepta 1, 2, 3 o 4 como entrada, puedes enviar otra solicitud con una de las entradas aceptadas (1, 2, 3 o 4) y resultará en una solicitud para ese paso.',
    'tooltip_ussd_delay' => 'Debes establecer un retraso mínimo de 30 segundos si planeas usar solo solicitudes USSD de un solo paso. Una solicitud USSD de múltiples pasos espera hasta 30 segundos para la siguiente entrada, por lo que si envías una nueva solicitud USSD antes de ese tiempo, se considerará una entrada para la solicitud de múltiples pasos anterior.',
    'ssl_verification' => 'Verificación de SSL',
    'off' => 'Apagado',
    'on_recommended' => 'Encendido (Recomendado)',
    'tooltip_only_shared_devices' => 'Puedes establecerlo en 0 si deseas que el usuario solo use los dispositivos compartidos por el administrador. Esto evitará que el usuario agregue su propio dispositivo al sistema.',
    'selected_users' => 'Usuarios seleccionados',
    'demo_users' => 'Usuarios de demostración',
    'share_with' => 'Compartir con',
    'shared_devices' => 'dispositivos compartidos por el administrador',
    'skin_setting' => 'Apariencia',
    'black' => 'Negro',
    'black_light' => 'Blanco claro',
    'blue' => 'Azul',
    'blue_light' => 'Azul claro',
    'green' => 'Verde',
    'green_light' => 'Verde claro',
    'purple' => 'Morado',
    'purple_light' => 'Morado claro',
    'red' => 'Rojo',
    'red_light' => 'Rojo claro',
    'yellow' => 'Amarillo',
    'yellow_light' => 'Amarillo claro',
    'add_numbers_blacklist_placeholder' => 'Ingresa un número de teléfono móvil por línea',
    'use_owner_settings' => 'Usar configuraciones relacionadas con el dispositivo (retraso, informes de entrega y cola progresiva) establecidas por el administrador',
    'get_devices' => 'Obtener dispositivos',
    'use_progressive_queue_setting' => 'Enviar el siguiente mensaje de la campaña solo después de que el mensaje actual sea procesado por el operador de la red',
    'hint' => '¡Consejo!',
    'blacklist_instruction' => 'Los usuarios pueden agregar su número a la lista negra respondiendo "STOP" a tu mensaje. Si también estás usando dispositivos compartidos por el administrador, deben usar "STOP %userID%" en lugar de "STOP" para agregar su número a la lista negra.',
    'error_no_valid_numbers_found' => 'No se encontraron números válidos que se puedan agregar a la lista negra.',
    'success_numbers_removed' => '%count% números eliminados correctamente.',
    'success_number_removed' => '%count% número eliminado correctamente.',
    'success_add_to_blacklist' => 'Agregado a la lista negra exitosamente.',
    'remove_number_from_black_list_confirmation' => '¿Estás seguro de que deseas eliminar los números seleccionados de la lista negra?',
    'add' => 'Agregar',
    'blacklist' => 'Lista negra',
    'unshareable' => 'No compartible',
    'error_device_not_owned' => 'Solo puedes enviar solicitudes USSD utilizando tus propios dispositivos.',
    'no_one' => 'Nadie',
    'shared_with' => 'Compartido con',
    'share_to_all' => 'Compartir con todos',
    'success_device_shared' => 'Dispositivo compartido/no compartido exitosamente.',
    'users' => 'Usuarios',
    'share_device' => 'Compartir dispositivo',
    'all' => 'Todos',
    'error_unable_to_remove_plans' => 'No se pueden eliminar los planes seleccionados.',
    'remove_plans_confirmation' => '¿Estás seguro de que deseas eliminar los planes seleccionados?',
    'success_plans_removed' => '%count% planes eliminados correctamente.',
    'success_plan_removed' => '%count% plan eliminado correctamente.',
    'success_regenerate_api_key' => 'Clave API regenerada exitosamente.',
    'regenerate_api_key_confirmation' => '¿Estás seguro de que deseas regenerar la clave API? ¡Tu clave antigua dejará de funcionar si haces esto!',
    'resend_requests_confirmation' => '¿Estás seguro de que deseas reenviar las solicitudes USSD seleccionadas?',
    'success_ussd_requests_resent' => '%count% solicitudes USSD reenviadas exitosamente.',
    'success_ussd_request_resent' => '%count% solicitud USSD reenviada exitosamente.',
    'move_contacts' => 'Mover contactos',
    'success_contacts_moved' => '%count% contactos movidos exitosamente.',
    'success_contact_moved' => '%count% contacto movido exitosamente.',
    'move_contacts_confirmation' => '¿Estás seguro de que deseas mover los contactos seleccionados?',
    'move' => 'Mover',
    'new_user_report_delivery_setting' => 'Solicitar un informe de entrega para cada mensaje enviado por el usuario (solo SMS)',
    'tooltip_sleep_time' => 'Si está habilitado, evitará el envío de todos los mensajes no prioritarios en este intervalo de tiempo.',
    'appearance' => 'Apariencia',
    'reset_password_link' => 'Enlace para restablecer contraseña',
    'user_limits_update' => 'Actualización de límites de usuario',
    'subject' => 'Asunto',
    'unsubscribe' => 'Cancelar suscripción',
    'copyright' => 'Derechos de autor',
    'android_app' => 'Aplicación de Android',
    'links' => 'Enlaces',
    'default_settings_new_users' => 'Configuración predeterminada para nuevos usuarios',
    'new_user_limitations' => 'Limitaciones para nuevos usuarios',
    'message_footer_demo_users' => 'Pie de página del mensaje para usuarios de demostración',
    'download_app' => 'Descargar aplicación',
    'no_ussd_requests_found' => 'No se encontraron solicitudes USSD.',
    'error_sim_not_exist' => 'Asegúrate de haber iniciado sesión en la aplicación en el dispositivo #%deviceId% y de que haya una tarjeta SIM en la ranura %simSlot%. Si la has insertado recientemente, abre la aplicación en el teléfono para agregarla a la base de datos.',
    'error_device_not_exist' => 'El ID de dispositivo que especificaste no se encuentra en la base de datos o no has iniciado sesión en la aplicación.',
    'success_ussd_requests_removed' => '%count% solicitudes USSD eliminadas correctamente.',
    'success_ussd_request_removed' => '%count% solicitud USSD eliminada correctamente.',
    'success_sent_ussd_request' => 'Solicitud USSD enviada correctamente.',
    'remove_requests_confirmation' => '¿Estás seguro de que deseas eliminar las solicitudes USSD seleccionadas?',
    'response_at' => 'Respuesta a las',
    'sent_at' => 'Enviada a las',
    'request' => 'Solicitud',
    'ussd_requests' => 'Solicitudes USSD',
    'ussd_request' => 'Solicitud USSD',
    'send_ussd_request' => 'Enviar solicitud USSD',
    'get_ussd_requests' => 'Obtener solicitudes USSD',
    'ussd' => 'USSD',
    'error_missing_data' => 'Faltan datos necesarios para darse de baja de la lista. Asegúrate de copiar la URL completa del mensaje.',
    'error_paypal_requires_ssl' => 'Necesitarás tener un certificado SSL instalado para tu dominio o subdominio para usar PayPal. Si ya lo has instalado, asegúrate de realizar esta acción desde una URL que comience con "https".',
    'tooltip_prioritize' => 'Enviar este mensaje de inmediato, incluso si hay otra campaña en cola.',
    'add_device_instruction' => 'Puedes seguir los siguientes pasos para agregar tu teléfono Android en el sistema.',
    'error_invalid_sleep_time' => 'Proporciona un valor de tiempo de espera válido. El valor de tiempo de espera "De" y "Hasta" deben ser diferentes.',
    'sleep_time_from' => 'Hora de inicio de tiempo de espera',
    'sleep_time_upto' => 'Hora de finalización de tiempo de espera',
    'sleep_time' => 'Tiempo de espera',
    'prioritize' => 'Priorizar',
    'success_contacts_list_updated' => 'Nombre de la lista de contactos actualizado correctamente.',
    'edit_contacts_list' => 'Editar lista de contactos',
    'edit_list' => 'Editar lista',
    'error_creating_lock_file' => 'Se produjo un error al crear el archivo de bloqueo. Asegúrate de que este script tenga los permisos necesarios para crear un directorio.',
    'refresh' => 'Actualizar',
    'success_queued_contacts_import' => 'Importación del archivo de contactos en cola correctamente.',
    'error_creating_directory' => 'Se produjo un error al crear el directorio %name%. Asegúrate de que este script tenga los permisos necesarios para crear un directorio.',
    'footer_text_label' => 'Texto del pie de página',
    'option' => 'Criterio de selección del dispositivo',
    'use_selected_devices' => 'Usar dispositivos seleccionados',
    'use_all_devices' => 'Usar la tarjeta SIM predeterminada de todos los dispositivos',
    'use_all_sims' => 'Usar todas las tarjetas SIM de todos los dispositivos',
    'use_random_device' => 'Usar un dispositivo o tarjeta SIM aleatoria de los dispositivos seleccionados',
    'tooltip_android_app_url' => 'Esta URL se utilizará como enlace al archivo APK en el correo electrónico de registro y otros lugares, así que asegúrate de cambiarlo por tu URL de APK.',
    'tooltip_mms' => 'La disponibilidad de MMS depende de tu país y del soporte de tu operador de red. El receptor debe ser capaz de recibir MMS para poder recibirlo. Esta función no debe confundirse con RCS o cualquier otra capacidad de mensajería proporcionada por el fabricante del dispositivo (por ejemplo, Samsung Message, Mi Message, etc.).',
    'tooltip_attachments' => 'Puedes adjuntar varios archivos aquí, pero asegúrate de no superar el límite total de tamaño de 600 KB. Si el receptor aún no puede recibir el MMS, puedes intentar no superar los 300 KB.',
    'attachments_invalid' => 'Los archivos adjuntos de imagen que has proporcionado no son válidos.',
    'resend_messages' => 'Volver a enviar mensajes',
    'error_creating_upload_directory' => 'Se produjo un error al crear el directorio de carga. Asegúrate de que este script tenga permisos para crear una carpeta.',
    'error_uploading_attachment' => 'Se produjo un error al cargar los archivos adjuntos. Asegúrate de que este script tenga permisos para escribir en la carpeta de carga.',
    'tooltip_attachments_links' => 'Puedes proporcionar varios enlaces de imagen separándolos con comas, pero asegúrate de que no haya espacios antes o después de la coma.',
    'attachments_links' => 'Enlaces a archivos adjuntos (*.png, *.jpg, *.gif, *.aac, *.3gp, *.amr, *.mp3, *.m4a, *.wav, *.mp4, *.txt, *.vcf, .html)',
    'attachments' => 'Archivos adjuntos (.png, *.jpg, *.gif, *.aac, *.3gp, *.amr, *.mp3, *.m4a, *.wav, *.mp4, *.txt, *.vcf, *.html)',
    'type' => 'Tipo',
    'success_device_name_updated' => 'Nombre de dispositivo guardado correctamente.',
    'edit_device' => 'Editar dispositivo',
    'send_received_messages_to_email' => 'Enviar mensajes recibidos por correo electrónico',
    'tooltip_pusher' => 'Obtén actualizaciones de estado en tiempo real de mensajes enviados y recibidos en el panel usando Pusher.',
    'app_id' => 'ID de aplicación',
    'key' => 'Clave',
    'cluster' => 'Cluster',
    'pusher' => 'Pusher',
    'error_server_requirements_not_met' => 'Tu servidor no cumple con los requisitos. Por favor, contacta al administrador de tu servidor para instalar las dependencias faltantes.',
    'next' => 'Siguiente',
    'none' => 'Ninguno',
    'success_templates_removed' => '%count% plantillas eliminadas exitosamente.',
    'success_template_removed' => '%count% plantilla eliminada exitosamente.',
    'success_update_template' => 'Plantilla de SMS actualizada exitosamente.',
    'success_add_template' => 'Plantilla de SMS agregada exitosamente.',
    'remove_templates_confirmation' => '¿Estás seguro de que deseas eliminar las plantillas de SMS seleccionadas?',
    'manage_templates' => 'Administrar plantillas',
    'add_template' => 'Agregar plantilla',
    'templates' => 'Plantillas',
    'template' => 'Plantilla',
    'tooltip_delay' => 'Puedes asignar un rango para el retraso aleatorio. Por ejemplo, si asignas 20-40 como valor de retraso, entonces el retraso se elegirá al azar para cada mensaje y estará entre 20 y 40 segundos.',
    'error_invalid_delay' => 'El retraso debe ser numérico (por ejemplo, 20) o representar un rango (por ejemplo, 20-60).',
    'error_max_delay_smaller' => 'El retraso máximo debe ser mayor que el retraso mínimo.',
    'error_disposable_email_address' => '¡Por favor, utiliza una dirección de correo electrónico no desechable para el registro!',
    'placeholder_auto_responder_message' => 'Puedes usar el símbolo | para separar varios mensajes. Si tu mensaje contiene |, puedes usar | en su lugar.',
    'tooltip_total_cycles' => 'Actívalo para limitar el número de veces que se cobrará la suscripción. Si no lo activas, una suscripción para este plan permanecerá activa hasta que se cancele.',
    'cancelled' => 'cancelada',
    'renews_until' => 'Renovación hasta',
    'refund' => 'Reembolso',
    'error_payment_not_found' => '¡No se pudo encontrar el pago!',
    'success_payment_refunded' => 'Pago reembolsado exitosamente.',
    'refund_payment_confirmation' => '¿Estás seguro de que deseas reembolsar este pago?',
    'error_user_already_subscribed' => 'No se puede crear una nueva suscripción porque ya existe una suscripción activa para este usuario.',
    'success_create_subscription' => 'Suscripción agregada exitosamente.',
    'year' => 'Año',
    'month' => 'Mes',
    'week' => 'Semana',
    'create_subscription' => 'Crear suscripción',
    'error_total_cycles_not_number' => 'El número total de ciclos debe ser un número mayor que cero.',
    'total_cycles' => 'Ciclos totales',
    'excel_message_placeholder' => 'Puedes usar un marcador de posición como se muestra en el siguiente mensaje y se reemplazará automáticamente con un valor apropiado. También admite la aleatorización de mensajes mediante spintax.
&quot;¡{Hi|Hola|Hey} %name%, ¿cómo estás?&quot;
En el ejemplo anterior, el sistema reemplazará %name% con los datos de la columna Nombre. Debes tener la columna Nombre en tu archivo de Excel para que funcione.',
    'do_not_have_an_account' => '¿No tienes una cuenta?',
    'user' => 'Usuario',
    'from_name' => 'Nombre del remitente',
    'from_address' => 'Dirección de correo electrónico del remitente',
    'tooltip_unsubscribe_url' => 'Puedes agregar una URL acortada para la URL de cancelación de suscripción para ahorrar espacio en tu mensaje.',
    'tooltip_max_retries' => 'El número máximo de veces que el sistema debe intentar enviar mensajes fallidos.',
    'tooltip_retry_time_interval' => 'El intervalo de tiempo entre cada reintento de mensajes fallidos.',
    'smtp_debug_information' => 'Información de depuración de SMTP',
    'show_debug_info' => 'Mostrar información de depuración',
    'tooltip_message_multiple' => 'Solo se utilizarán los números de teléfono móvil del archivo de Excel cuando ingreses algo en este campo.',
    'buy_now' => 'Comprar ahora',
    'favicon' => 'Favicon',
    'error_uploading_logo' => 'Se produjo un error al cargar el logotipo. Asegúrate de que el script tenga permisos para escribir en la carpeta de uploads.',
    'logo' => 'Logotipo',
    'expires_after' => 'Expira después de',
    'add_unsubscribe_link' => 'Agregar enlace de cancelación de suscripción',
    'cycles_competed' => 'Ciclos completados',
    'respond_if' => 'Responder si',
    'exact_case_sensitive' => 'Coincidencia exacta (distinción entre mayúsculas y minúsculas)',
    'exact_case_insensitive' => 'Coincidencia exacta (sin distinción entre mayúsculas y minúsculas)',
    'contains' => 'Contiene el mensaje',
    'regular_expression' => 'Coincide con la expresión regular',
    'success_update_response' => 'Respuesta actualizada exitosamente.',
    'edit_response' => 'Editar respuesta',
    'success_responses_removed' => '%count% respuestas eliminadas exitosamente.',
    'success_response_removed' => '%count% respuesta eliminada exitosamente.',
    'remove_responses_confirmation' => '¿Estás seguro de que deseas eliminar las respuestas seleccionadas?',
    'error_unable_to_remove_responses' => 'No se pueden eliminar las respuestas seleccionadas',
    'response' => 'Respuesta',
    'success_add_response' => 'Respuesta agregada exitosamente.',
    'responses' => 'Respuestas',
    'add_response' => 'Agregar respuesta',
    'auto_responder' => 'Respuesta automática',
    'unlimited_credits' => 'créditos ilimitados',
    'credit' => 'crédito',
    'error_contacts_limit_reached' => 'Se ha alcanzado el número máximo de contactos permitidos para esta cuenta.',
    'contact' => 'contacto',
    'unlimited_contacts' => 'contactos ilimitados',
    'unlimited_devices' => 'dispositivos ilimitados',
    'max_contacts' => 'Máximo de contactos',
    'error_max_contacts_not_number' => 'El número máximo de contactos debe ser un número.',
    'earnings' => 'Ganancias',
    'active_subscriptions' => 'Suscripciones activas',
    'auto_retry_setting' => 'Reintentar automáticamente los mensajes fallidos',
    'hour' => 'hora',
    'hours' => 'horas',
    'day' => 'día',
    'minutes' => 'minutos',
    'retry_time_interval_label' => 'Intervalo de tiempo de reintentos',
    'max_retries_label' => 'Reintentos máximos',
    'error_subscription_expired' => 'Tu suscripción ha expirado. Renueva tu suscripción para seguir utilizando esta aplicación.',
    'no' => 'No',
    'yes' => 'Sí',
    'all_time' => 'Todo el tiempo',
    'never' => 'Nunca',
    'days' => 'Días',
    'cancel_subscription_confirmation' => '¿Estás seguro de que deseas cancelar esta suscripción?',
    'id' => 'ID',
    'reply' => 'Responder',
    'unlimited' => 'Ilimitado',
    'forever' => 'para siempre',
    'expiry_date' => 'Fecha de vencimiento',
    'payment_id' => 'ID de pago',
    'amount' => 'Cantidad',
    'transaction_fee' => 'Tarifa de transacción',
    'payments' => 'Pagos',
    'payment_method' => 'Método de pago',
    'subscribed_date' => 'Fecha de suscripción',
    'renew_date' => 'Fecha de renovación',
    'subscription_id' => 'ID de suscripción',
    'plan_already_exists' => 'Ya existe un plan con el mismo nombre.',
    'switch_plan' => 'Cambiar plan',
    'success_subscription_canceled' => 'Suscripción cancelada exitosamente.',
    'error_subscription_not_found' => '¡No se pudo encontrar la suscripción!',
    'success_subscribed' => 'Te has suscrito exitosamente al plan de suscripción.',
    'cancel' => 'Cancelar',
    'subscribe' => 'Suscribirse',
    'subscriptions' => 'Suscripciones',
    'success_edit_plan' => 'Plan de suscripción actualizado exitosamente.',
    'enabled' => 'Habilitado',
    'billing_cycle' => 'Ciclo de facturación',
    'success_create_plan' => 'Nuevo plan de suscripción agregado exitosamente.',
    'edit_plan' => 'Editar plan',
    'frequency_unit' => 'Unidad de frecuencia',
    'frequency' => 'Frecuencia',
    'currency' => 'Moneda',
    'price' => 'Precio',
    'add_plan_form_title' => 'Agregar plan',
    'plans' => 'Planes',
    'plan' => 'Plan',
    'error_updating_config' => 'No se puede actualizar el archivo de configuración. Asegúrate de que este script tenga los permisos adecuados para actualizar un archivo.',
    'enable_registration' => 'Habilitar registro',
    'error_invalid_integer_value' => 'Valor no válido proporcionado para %field%. Debe ser un valor numérico válido.',
    'credentials_type' => 'Tipo de credenciales',
    'client_id' => 'ID de cliente',
    'secret' => 'Secreto',
    'payment_gateway' => 'Pasarela de pago',
    'emails' => 'Correos electrónicos',
    'success_save_settings' => 'Configuración guardada exitosamente.',
    'general' => 'General',
    'registration' => 'Registro',
    'site_name' => 'Nombre del sitio',
    'site_description' => 'Descripción del sitio',
    'copyright_name' => 'Nombre de derechos de autor',
    'language' => 'Idioma',
    'secret_key' => 'Clave secreta',
    'site_key' => 'Clave del sitio',
    'hostname' => 'Nombre de host',
    'port' => 'Puerto',
    'encryption' => 'Encriptación',
    'debug' => 'Depuración',
    'username' => 'Nombre de usuario',
    'application_copyright' => '<strong>Derechos de autor © 2018-%present% <a href="%url%" id="company_url">%name%</a></strong>. Todos los derechosreservados.',
    'add_device_instructions' => 'Puedes seguir los siguientes pasos para agregar tu teléfono Android al sistema.',
    'add_device_step_1' => 'Descarga la última versión de la aplicación de Android desde <a href="%app_url%">aquí</a>. Es mejor si lo descargas directamente en tu teléfono.',
    'add_device_step_2' => 'Instálalo en tu teléfono. Si no sabes cómo instalar aplicaciones que no están disponibles en Play Store, puedes seguir <a href="https://android.gadgethacks.com/how-to/android-101-sideload-apps-by-enabling-unknown-sources-install-unknown-apps-0161947/" target="_blank">esta guía</a>.',
    'add_device_step_3' => 'Abre la aplicación después de la instalación, se te pedirá que concedas varios permisos. Simplemente haz clic en Permitir o Sí en todas las ventanas emergentes que aparezcan y se te presentará la ventana de inicio de sesión. Toca el botón "INICIAR SESIÓN USANDO CÓDIGO QR" para escanear el código QR que se muestra a continuación.',
    'add_device_step_4' => '¡Felicidades! Has agregado exitosamente tu teléfono Android al sistema. Ahora solo abre la página de Envío utilizando el menú de navegación y comienza a enviar mensajes.',
    'add_device' => 'Agregar dispositivo',
    'error_parsing_qr_code' => 'Se produjo un error al analizar el código QR. Por favor, intenta escanearlo nuevamente.',
    'null_value' => 'Desconocido',
    'android_version' => 'Versión de Android',
    'app_version' => 'Versión de la aplicación',
    'error_invalid_schedule_time' => 'La hora programada debe ser mayor que la hora actual.',
    'success_messages_scheduled' => '%count% mensajes programados exitosamente.',
    'success_message_scheduled' => '%count% mensaje programado exitosamente.',
    'success_scheduled' => 'Mensaje programado exitosamente.',
    'faqs' => 'Preguntas frecuentes',
    'support' => 'Soporte',
    'faqs_link' => 'Puedes encontrar preguntas frecuentes en <a target="_blank" href="https://support.rbsoft.org/knowledgebase/355">este enlace</a>.',
    'support_link' => 'Si las preguntas frecuentes no resuelven el problema que estás experimentando, puedes abrir un ticket de soporte en <a target="_blank" href="https://support.rbsoft.org">este enlace</a>.',
    'cron_job_instructions' => 'Agrega una tarea cron ejecutando el siguiente comando en la terminal de Linux. Si estás utilizando Cpanel o Vesta Panel, sigue una guía en <a target="_blank" href="https://smsgateway.rbsoft.org/docs/setting_up_the_cron_job_1.htm">este enlace</a> para configurar una tarea cron.',
    'cron_job' => 'Tarea cron para mensajes programados',
    'success_installation' => 'La instalación se ha completado con éxito.',
    'schedule' => 'Programar',
    'scheduled' => 'Programado',
    'tooltip_schedule' => 'La programación utiliza la zona horaria que has establecido en tu página de perfil, así que asegúrate de que sea la misma que la zona horaria de tu dispositivo.',
    'error_missing_excel_file' => 'Por favor, busca y selecciona el archivo de Excel que deseas cargar.',
    'send_message_to_contacts' => 'Enviar un mensaje a la lista de contactos',
    'contacts_message_placeholder' => 'Puedes usar marcadores de posición como se muestra en el siguiente mensaje y se reemplazarán automáticamente por un valor apropiado. También admite la aleatorización del mensaje utilizando spintax.
&quot;¡{Hi|Hola|Hey} %name%, ¿cómo estás?&quot;',
    'change_subscription' => 'Cambiar suscripción',
    'manage_contacts' => 'Gestionar contactos',
    'subscribed' => 'Suscrito',
    'remove_list' => 'Eliminar lista',
    'contacts_list' => 'Lista de contactos',
    'import_contacts' => 'Importar contactos',
    'unsubscribe_link' => 'Para cancelar la suscripción, haz clic en el siguiente enlace o responde "CANCELAR SUSCRIPCIÓN %listId%".\n%unsubscribeURL%?number=%number%&listID=%listID%',
    'error_invalid_list_id' => '¡ID de lista no válido! No se puede encontrar la lista de contactos.',
    'change_subscription_confirmation' => '¿Estás seguro de que deseas cambiar el estado de suscripción de los contactos seleccionados?',
    'error_already_unsubscribed' => 'Este número ya se ha dado de baja de la lista.',
    'error_no_subscribers' => 'No hay suscriptores en la lista de contactos.',
    'error_not_a_subscriber' => 'Este número no está en la lista de suscriptores.',
    'error_invalid_number' => 'Este número de teléfono móvil no se encuentra en la lista. Por favor, proporciona un número de teléfono válido.',
    'success_unsubscribed' => 'Te has dado de baja de la lista de contactos.',
    'success_contacts_subscription_changed' => 'Se ha cambiado el estado de suscripción correctamente para %count% contactos.',
    'success_contact_subscription_changed' => 'Se ha cambiado el estado de suscripción correctamente para %count% contacto.',
    'success_contacts_removed' => 'Se han eliminado %count% contactos correctamente.',
    'success_contacts_list_removed' => 'Lista de contactos eliminada correctamente.',
    'success_contact_removed' => 'Se ha eliminado %count% contacto correctamente.',
    'remove_contacts_confirmation' => '¿Estás seguro de que deseas eliminar los contactos seleccionados?',
    'error_no_contacts_found' => 'No se encontraron nuevos contactos en el archivo cargado.',
    'success_contacts_saved' => 'Se han agregado %count% contactos correctamente.',
    'success_contact_saved' => 'Se ha agregado %count% contacto correctamente.',
    'error_contacts_list_exist' => 'Ya existe una lista de contactos con este nombre. Por favor, proporciona un nombre único.',
    'error_contact_exist' => 'Este número de teléfono ya existe en la lista de contactos.',
    'success_new_contact' => 'Contacto agregado correctamente.',
    'error_list_name_required' => 'El nombre de la lista de contactos no debe estar vacío.',
    'success_create_list' => 'Se ha agregado correctamente una nueva lista de contactos.',
    'remove_contacts_list_confirmation' => '¿Estás seguro de que deseas eliminar las listas de contactos seleccionadas?',
    'add_contact' => 'Agregar contacto',
    'contacts' => 'Contactos',
    'create_list' => 'Crear lista de contactos',
    'list_name' => 'Nombre de la lista de contactos',
    'create' => 'Crear',
    'delivered' => 'Entregado',
    'default' => 'Predeterminado',
    'sim' => 'SIM',
    'error_no_sim_present' => 'No hay una tarjeta SIM en la ranura %slot%. Reinicia la aplicación SMS Gateway en tu dispositivo Android si has insertado la tarjeta SIM recientemente.',
    'sent_date' => 'Fecha de envío',
    'delivered_date' => 'Fecha de entrega',
    'sign_in' => 'Iniciar sesión',
    'sign_in_message' => 'Inicia sesión para comenzar tu sesión',
    'forget_password_link' => 'Olvidé mi contraseña',
    'error_removing_upgrade_script' => '%type% se ha completado correctamente, pero hay un error al eliminar "upgrade.php". Por favor, elimínalo manualmente y después haz clic <a href="index.php">aquí</a> para iniciar sesión.',
    'error_removing_install_directory' => 'Hay un error al eliminar el directorio "install". Por favor, elimínalo manualmente para continuar.',
    'error_incorrect_credentials' => 'Este correo electrónico o contraseña es incorrecto.',
    'error_incorrect_api_key' => 'Esta clave API no es válida.',
    'success_update' => 'Actualizado correctamente a la versión v%version%. Haz clic <a href="index.php">aquí</a> para iniciar sesión.',
    'purchase_code' => 'Código de compra de Envato',
    'dashboard' => 'Panel de control',
    'more_info' => 'Más información',
    'sent' => 'Enviado',
    'failed' => 'Fallido',
    'available' => 'Créditos disponibles',
    'used' => 'Créditos utilizados',
    'queued' => 'En cola',
    'pending' => 'Pendiente',
    'profile' => 'Perfil',
    'edit_user' => 'Editar usuario',
    'close' => 'Cerrar',
    'save_changes' => 'Guardar cambios',
    'add_webhook' => 'Agregar WebHook para mensajes recibidos',
    'webhook_url' => 'URL del WebHook',
    'api' => 'API',
    'api_test' => 'Generar enlace para probar la API',
    'api_key' => 'Clave de la API',
    'generate_link' => 'Generar enlace',
    'manage_users' => 'Gestionar usuarios',
    'select_user' => 'Seleccionar usuario',
    'messages' => 'Mensajes',
    'sender' => 'Remitente',
    'devices' => 'Dispositivos',
    'select_device' => 'Seleccionar dispositivo',
    'online' => 'En línea',
    'download_example_excel' => 'Descargar archivo de ejemplo',
    'installation' => 'Instalación',
    'installation_of_app' => 'Instalación de %app%',
    'toggle_navigation' => 'Alternar navegación',
    'error_creating_config' => 'No se puede crear el archivo de configuración. Asegúrate de que este script tenga los permisos adecuados para crear un archivo.',
    'error_device_not_found' => 'Este dispositivo no existe en la base de datos.',
    'error_email_registered' => 'Este correo electrónico ya está registrado.',
    'error_credits_depleted' => 'No tienes suficientes créditos para completar esta operación. Por favor, obtén más créditos para continuar.',
    'error_send_email_register' => 'Se produjo un error al enviar el correo electrónico de información de registro. %errorMessage%',
    'success_registration' => 'El usuario se ha agregado correctamente a la base de datos. Pronto recibirán información de registro por correo electrónico.',
    'add_user_form_title' => 'Agregar nuevo usuario',
    'error_dialog_title' => '¡Error!',
    'success_dialog_title' => 'Éxito',
    'name' => 'Nombre',
    'error_name_empty' => 'El nombre no debe estar vacío.',
    'device_name' => 'Nombre del dispositivo',
    'email' => 'Correo electrónico',
    'device_model' => 'Modelo del dispositivo',
    'password' => 'Contraseña',
    'confirm_email' => 'Confirmar correo electrónico',
    'create_user' => 'Crear usuario',
    'remove' => 'Eliminar',
    'database_server' => 'Servidor de base de datos',
    'database_name' => 'Nombre de la base de datos',
    'database_user' => 'Usuario de la base de datos',
    'database_password' => 'Contraseña de la base de datos',
    'install' => 'Instalar',
    'total_messages' => 'Total de mensajes',
    'connected_devices' => 'Dispositivos conectados',
    'mobile_numbers' => 'Números de móvil',
    'mobile_numbers_placeholder' => '+911234567890,+912345678901',
    'device_status' => 'Estado del dispositivo',
    'date_added' => 'Fecha de añadido',
    'error_uploading_excel_file' => 'Hubo un problema al cargar este archivo. Por favor, inténtalo de nuevo más tarde.',
    'error_no_device_selected' => 'Por favor, selecciona al menos un dispositivo para enviar mensajes.',
    'error_unable_to_remove_users' => 'No se pueden eliminar los usuarios seleccionados.',
    'error_unable_to_remove_devices' => 'No se pueden eliminar los dispositivos seleccionados.',
    'remove_devices_confirmation' => '¿Estás seguro de que deseas eliminar los dispositivos seleccionados?',
    'remove_messages_confirmation' => '¿Estás seguro de que deseas eliminar los mensajes seleccionados?',
    'remove_users_confirmation' => 'Los usuarios seleccionados se eliminarán junto con sus mensajes. ¿Estás seguro de que deseas eliminar los usuarios seleccionados?',
    'search_form_title' => 'Buscar mensajes',
    'success_edit_user' => 'Los datos se guardaron correctamente para el usuario %name% [<a href="mailto:%email%">%email%</a>].',
    'all_users' => 'Todos los usuarios',
    'all_devices' => 'Todos los dispositivos',
    'unknown_device' => 'Desconocido',
    'credits' => 'Créditos',
    'max_devices' => 'Máximo de dispositivos',
    'mobile_number' => 'Número de móvil',
    'last_login' => 'Último inicio de sesión',
    'split' => 'Dividir mensajes entre dispositivos',
    'status' => 'Estado',
    'status_all' => 'Todos',
    'start_date' => 'Fecha de inicio',
    'end_date' => 'Fecha de finalización',
    'page_no' => 'Número de página',
    'select_all' => 'Seleccionar todo',
    'search' => 'Buscar',
    'export' => 'Exportar',
    'resend' => 'Reenviar',
    'delay' => 'Retraso',
    'timezone' => 'Zona horaria',
    'device' => 'Dispositivo',
    'save' => 'Guardar',
    'page_limit' => 'Número de mensajes por página',
    'received' => 'Recibido',
    'primary_device' => 'Dispositivo principal',
    'device_settings' => 'Configuración del dispositivo',
    'messages_count' => 'Mostrando ${start}-${end} de ${result.totalCount} mensajes',
    'no_messages_found' => 'No se encontraron mensajes.',
    'error_dialog_message' => 'No se pudo completar la operación.',
    'success_dialog_message' => 'La operación se completó correctamente.',
    'error_devices_limit_reached' => 'Se ha alcanzado el límite de dispositivos activos permitidos para esta cuenta.',
    'error_max_devices_not_number' => 'El máximo número de dispositivos debe ser un número.',
    'error_credits_not_number' => 'Los créditos de mensajes deben ser un número.',
    'error_password_incorrect' => 'La contraseña actual es incorrecta.',
    'error_delay_limit' => "El retraso debe estar entre 0 y 120 segundos.",
    'error_delay_not_numeric' => "El retraso debe ser numérico.",
    'error_device_name' => 'El nombre del dispositivo debe tener menos de 25 caracteres.',
    'success_device_settings' => 'Configuración del dispositivo guardada correctamente',
    'success_password_changed' => '¡Tu contraseña se ha cambiado correctamente!',
    'success_settings_changed' => 'Tus configuraciones se han cambiado correctamente.',
    'change_password' => 'Cambiar contraseña',
    'current_password' => 'Contraseña actual',
    'new_password' => 'Nueva contraseña',
    'confirm_password' => 'Confirmar contraseña',
    'settings' => 'Configuraciones',
    'delay_setting' => 'Retraso entre mensajes (0-120)',
    'report_delivery_setting' => 'Solicitar un informe de entrega para cada mensaje que envíes (Solo SMS)',
    'success_devices_removed' => '%count% dispositivos eliminados correctamente.',
    'success_device_removed' => '%count% dispositivo eliminado correctamente.',
    'success_users_removed' => '%count% usuarios eliminados correctamente.',
    'success_user_removed' => '%count% usuario eliminado correctamente.',
    'success_messages_removed' => '%count% mensajes eliminados correctamente.',
    'success_message_removed' => '%count% mensaje eliminado correctamente.',
    'success_messages_sent' => '%count% mensajes enviados correctamente.',
    'success_message_sent' => '%count% mensaje enviado correctamente.',
    'error_zero_messages' => 'No hay mensajes para enviar.',
    'error_invalid_request_format' => 'Formato de solicitud no válido.',
    'error_use_valid_number' => 'Por favor, utiliza un número de móvil válido.',
    'reset_password' => 'Restablecer contraseña',
    'error_email_not_exist' => 'Este correo electrónico no existe en la base de datos.',
    'error_link_expired' => 'Tu enlace de restablecimiento de contraseña ha caducado.',
    'error_link_invalid' => 'Tu enlace de restablecimiento de contraseña no es válido.',
    'error_send_email_reset_password' => 'Se produjo un error al enviar la información de restablecimiento de contraseña.',
    'success_reset_password' => '¡Tu contraseña se ha restablecido correctamente! Pronto recibirás nuevas credenciales de inicio de sesión por correo electrónico.',
    'success_password_reset_link' => 'Pronto recibirás un enlace para restablecer la contraseña por correo electrónico.',
    'forget_password' => 'Olvidé mi contraseña',
    'reset_your_password' => 'Restablece tu contraseña',
    'message' => 'Mensaje',
    'send' => 'Enviar',
    'send_multiple_messages' => 'Enviar varios mensajes',
    'send_message' => 'Enviar mensaje',
    'php_integration' => 'Integración de PHP',
    'php_integration_instruction' => 'Incluye el siguiente código en tu archivo PHP para comenzar a enviar mensajes.',
    'webhook_example' => 'Script de ejemplo de WebHook',
    'webhook_instruction' => 'Crea un script con el siguiente contenido y proporciona su URL como WebHook.',
    'success_save_webhook' => 'WebHook guardado correctamente.',
    'error_invalid_webhook_url' => 'Proporciona una URL válida para el WebHook.',
    'success_remove_webhook' => 'WebHook eliminado correctamente.',
    'send_single_message' => 'Enviar un solo mensaje',
    'send_bulk_messages' => 'Enviar mensajes en masa',
    'get_balance' => 'Obtener créditos de mensajes restantes',
    'get_messages' => 'Obtener mensajes y su estado actual',
    'get_credits' => 'Obtener créditos',
    'c#_integration' => 'Integración de C# (<a href="https://github.com/ravibpatel/Gateway-Sample-Application" target="_blank">Proyecto de ejemplo</a>)',
    'c#_integration_instruction' => 'Simplemente crea un archivo llamado Gateway.cs en tu proyecto y pega el siguiente código en él. También necesitarás agregar el paquete <a href="https://www.nuget.org/packages/Newtonsoft.Json" target="_blank">Newtonsoft.Json</a> a tu proyecto.',
    'error_missing_fields' => 'Todos los campos son obligatorios.',
    'success_sent' => 'Mensaje enviado correctamente.',
    'disconnected' => 'Desconectado',
    'connected' => 'Conectado',
    'success_register' => 'Gracias por tu interés en %app%. Recibirás información de registro por correo electrónico pronto.',
    'register' => 'Registrarse',
    'register_demo' => 'Registrarse para una demostración',
    'register_sign_in_link' => 'Ya tengo una membresía',
    'error_captcha_failed' => 'La verificación de Captcha falló, por favor, inténtalo de nuevo.',
    'error_no_active_device_found' => 'No se encontró ningún dispositivo activo asociado a esta cuenta de usuario.',
    'error_unable_to_connect_user' => 'No se puede conectar al dispositivo. Asegúrate de haber iniciado sesión en la aplicación en %device%.',
    'error_unable_to_connect_other' => 'No se puede conectar al dispositivo. Asegúrate de que el usuario %user% (%userEmail%) haya iniciado sesión en la aplicación en %device%.',
    'error_no_messages_found' => 'No se encontraron mensajes en el archivo cargado.',
    'error_nothing_to_update' => 'No hay cambios para actualizar.',
    'error_blocked_file_extension' => 'No se puede cargar el archivo. Esta extensión de archivo no está permitida.',
    'upload_excel_file' => 'Arrastra el archivo de Excel aquí o haz clic para cargarlo.',
    'upload_excel_file_mobile' => 'Toca aquí para cargar el archivo de Excel.',
    'register_email_subject' => '%app% Panel de Administración | Información de registro',
    'register_email_body' => '<p>Hola %user%,</p>

<p>Bienvenido al Panel de Administración de %app%.</p>
<p>Tu registro ha sido confirmado y ahora tienes acceso al Panel de Administración de %app%.</p>
<p>
Tu inicio de sesión:<br/>
Servidor: <a href="%server%">%server%</a><br/>
Correo electrónico: %userEmail%<br/>
Contraseña: %password%<br/>
</p>
<p>Necesitas descargar la aplicación de Android desde <a href="%appUrl%">aquí</a> e ingresar la información anterior para comenzar. Si no sabes cómo instalar aplicaciones de fuentes desconocidas, puedes seguir la <a href="https://android.gadgethacks.com/how-to/android-basics-enable-unknown-sources-sideload-apps-0161947/">guía para instalar aplicaciones de fuentes desconocidas</a>.</p>
<p>Puedes iniciar sesión utilizando las credenciales proporcionadas anteriormente o puedes utilizar el botón "INICIAR SESIÓN USANDO CÓDIGO QR" y escanear el código QR adjunto para iniciar sesión automáticamente.</p>
<p>Tienes %credits%. Puedes enviar mensajes utilizando %devices%. Puedes almacenar %contacts%. Tus créditos son válidos hasta %expiryDate%. Si deseas cambiar alguno de estos límites, por favor, ponte en contacto con <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>
<p>
Saludos,<br/>
%admin%
</p>',
    'reset_password_email_subject' => '%app% Panel de Administración | Restablecer contraseña',
    'reset_password_email_body' => '<p>Hola %user%,</p>
<p>Tu contraseña se ha restablecido correctamente. Puedes iniciar sesión en el Panel de Administración de %app% utilizando las siguientes credenciales.</p>
<p>
Tu inicio de sesión:<br/>
Servidor: <a href="%server%">%server%</a><br/>       
Correo electrónico: %userEmail%<br/>
Contraseña: %password%<br/>
</p>
<p>Si tienes alguna pregunta, por favor, ponte en contacto con <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>
<p>
Saludos,<br/>
%admin%<br/>
</p>',
    'reset_password_link_email_subject' => '%app% Panel de Administración | Enlace para restablecer contraseña',
    'reset_password_link_email_body' => '<p>Hola %user%,</p>
<p>Utiliza el siguiente enlace para restablecer tu contraseña. Este enlace caducará después de 24 horas.</p>
<h2><a href="%server%/reset-password.php?email=%userEmail%&code=%code%">Haz clic aquí para restablecer tu contraseña</a></h2>
<p>Si tienes alguna pregunta, por favor, ponte en contacto con <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>
<p>
Saludos,<br/>
%admin%<br/>
</p>',
    'edit_user_subject' => '%app% | Límites actualizados',
    'edit_user_email_body' => '<p>Hola %user%,</p>
<p>Ahora tienes %credits%. Puedes enviar mensajes utilizando %devices%. Puedes almacenar %contacts%. Tus créditos son válidos hasta %expiryDate%.</p>
<p>Si tienes alguna pregunta, por favor, ponte en contacto con <a href="mailto:%adminEmail%">%adminEmail%</a>.</p>
<p>
Saludos,<br/>
%admin%<br/>
    </p>'
];

// Application specific
include __DIR__ . "/../app.php";

// Internal
if (file_exists(__DIR__ . "/../internal.php")) {
    include __DIR__ . "/../internal.php";
}